# Contributing to meshrcnn
We want to make contributing to this project as easy and transparent as
possible.

## Our Development Process
While this codebase focuses on reproducing our paper results, we believe it could
be extended and improved in many ways. Thus, feel free to suggest improvements
or extensions.

## Pull Requests
We actively welcome your pull requests.

1. Fork the repo and create your branch from `master`.
2. If you've changed APIs, update the documentation.
4. Train and report performance of all models (and baselines if applicable).
5. Make sure your code lints `./infra/linter.sh`.
6. If a PR contains multiple orthogonal changes, split it to several PRs.
7. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## License
By contributing to meshrcnn, you agree that your contributions will be licensed
under the LICENSE file in the root directory of this source tree.
