function X=addnoise(m,d,X,noise,maxnoise,n1)
% addnoise corrupts the original i.i.d. sample
% Parameters:
% m: the number of observed nodes
% d: the dimension of the random vector
% X: the original i.i.d. data matrix
% noise: the pattern of the noise
% maxnoise: the amplitude parameter of the noise
% n1: the corruption level
noise_num=floor(n1/2);
[n,len]=size(X);
switch noise
    case 'indepGaussian'
        % maxnoise is the standard variance
        for i=1:len
            index=randperm(n);
            index=index(1:noise_num);
            noise=mvnrnd(0,maxnoise^2,noise_num);
            X(index,i)=X(index,i)+noise;
        end
        
    case 'indeplargenoise'
        % the amplitudes of noises are in [-2*maxnoise,2*maxnoise]
        for i=1:len
            index=randperm(n);
            index=index(1:noise_num);
            noise=2*maxnoise*(2*rand(noise_num,1)-ones(noise_num,1));
            X(index,i)=X(index,i)+noise;
        end
        
    case 'constnoise'
        % the amplitudes of noises are 'maxnoise', '-maxnoise'
        for i=1:len
            index=randperm(n);
            index=index(1:noise_num);
            noise=maxnoise*binornd(1,0.5,noise_num,1);
            X(index,i)=X(index,i)+noise;
        end
        
     
    case 'hmm'
        rate=[1 0.9 0.8];
        adjmat=makeModel('hmm', m);
        [root,~]=size(adjmat);
        rho=0.8;
        temp=randn(d,d);
        Sigma_r=2*temp*temp.'+maxnoise^2*(rate.'*rate+eye(d));
        [V,D]=eig(Sigma_r);
        LambdaA=diag([rho,0.98*rho,0.97*rho]);
        Lambdan=D-LambdaA*D*LambdaA;
        A=V*LambdaA*V.';
        Sigma_n=V*Lambdan*V.';
        X_noise=samplegeneimprv(adjmat,root,A,Sigma_r,Sigma_n,m,n);
        for i=1:len
            index=randperm(n);
            index=index(1:noise_num);
            X(index,i)=X_noise(index,i);
        end
        
    case 'doublebinary'
        rate=[1 0.9 0.8];
        adjmat=makeModel('doublebinary', m);
        [root,~]=size(adjmat);
        rho=0.8;
        temp=randn(d,d);
        Sigma_r=2*temp*temp.'+maxnoise^2*(rate.'*rate+eye(d));
        [V,D]=eig(Sigma_r);
        LambdaA=diag([rho,0.98*rho,0.97*rho]);
        Lambdan=D-LambdaA*D*LambdaA;
        A=V*LambdaA*V.';
        Sigma_n=V*Lambdan*V.';
        X_noise=samplegeneimprv(adjmat,root,A,Sigma_r,Sigma_n,m,n);
        for i=1:len
            index=randperm(n);
            index=index(1:noise_num);
            X(index,i)=X_noise(index,i);
        end
        
    case 'outlierGaussian'
        index=1:noise_num;
        for i=1:len
            noise=mvnrnd(0,maxnoise^2,noise_num);
            X(index,i)=X(index,i)+noise;
        end
        
    case 'outlierhmm'
        rate=[1 0.9 0.8];
        adjmat=makeModel('hmm', m);
        [root,~]=size(adjmat);
        rho=0.8;
        temp=randn(d,d);
        Sigma_r=2*temp*temp.'+maxnoise^2*(rate.'*rate+eye(d));
        [V,D]=eig(Sigma_r);
        LambdaA=diag([rho,0.98*rho,0.97*rho]);
        Lambdan=D-LambdaA*D*LambdaA;
        A=V*LambdaA*V.';
        Sigma_n=V*Lambdan*V.';
        X_noise=samplegeneimprv(adjmat,root,A,Sigma_r,Sigma_n,m,n);
        index=1:noise_num;
        X(index,:)=X_noise(index,:);
        
    case 'outlierdb'
        rate=[1 0.9 0.8];
        adjmat=makeModel('doublebinary', m);
        [root,~]=size(adjmat);
        rho=0.8;
        temp=randn(d,d);
        Sigma_r=2*temp*temp.'+maxnoise^2*(rate.'*rate+eye(d));
        [V,D]=eig(Sigma_r);
        LambdaA=diag([rho,0.98*rho,0.97*rho]);
        Lambdan=D-LambdaA*D*LambdaA;
        A=V*LambdaA*V.';
        Sigma_n=V*Lambdan*V.';
        X_noise=samplegeneimprv(adjmat,root,A,Sigma_r,Sigma_n,m,n);
        index=1:noise_num;
        X(index,:)=X_noise(index,:);
end
        
        
        
        
        