function [consistent, grouping] = checkConsistency(A, epsilon)



% Threshold a mtrix A with epsilon and check whether it gives a consistent

% grouping of elements.



m = size(A,1);

B = (A < epsilon);

B = B | B' | diag(true(m,1));

all_element_set = 1:m;
element_set = all_element_set;

consistent = true;

grouping = {};

is_grouped = false(m,1);

while(~all(is_grouped) && consistent)
%while(~isempty(element_set) && consistent)

    i = element_set(1);

    members = B(i,:);

    membersB = B(members,members);

    if(all(membersB))

        B(members,members) = false;

        member_inds = find(members);

        %element_set = setdiff(element_set, member_inds);
        is_grouped(member_inds) = true;
        element_set = all_element_set(~is_grouped);

        grouping = [grouping; {member_inds}];

    else

        consistent = false;

    end    

end

if(length(grouping) >= m-1)
    consistent = false;
end