function currDist = computeHiddenStats(distance, adjNewOld)

% Compute distance between nodes using the Markov property
% PARAMETERS:
%   distance = distance matrix between observed nodes
%   nodeSet = a set of nodes (both observed and hidden) to compute
%   distances
%   adjNewOld = adjacency matrix between nextNodeSet and nodeSet (which
%   indexes the distance matrix)

M = size(adjNewOld,1);
currDist = zeros(M,M);
family_ind = adjNewOld;
in_family_dist_sum = zeros(M,1);
degree = sum(family_ind,2);

for i=1:M
    if(degree(i)> 1)
        in_family_dist_mat = distance(family_ind(i,:),family_ind(i,:));
        in_family_dist_sum(i) = sum(in_family_dist_mat(:))/(2*(degree(i)-1));
    end
end

for i=1:M
    for j=i+1:M
        inter_family_dist_mat = distance(family_ind(i,:),family_ind(j,:));
        inter_family_dist_sum = sum(inter_family_dist_mat(:));
        num_pairs = numel(inter_family_dist_mat);
        currDist(i,j) = (inter_family_dist_sum - in_family_dist_sum(i) - in_family_dist_sum(j))/num_pairs;
    end
end

currDist = currDist + currDist';

        

