clc;
close all
clear all
addpath ./toolbox

%graph = 'star'
%graph = 'doubleStar'
graphm = 'hmm';
%graph = '5cayley'
%graphm = 'fulltriple'
%graphm = 'doublebinary'
%dist = 'gaussian';

m = 80;  % Number of observed variables
%nset = [1, 2, 10, 20, 100, 200]*1000; % Number of samples to test
nset = [0.5,1,1.5,2,5,10,20]*1000;
%nset=500;
n1=100;
num_runs = 2; % Change this to 200 to get reliable performance comparisons

save_result = false;
draw_figure = false;
useDistances = true;

% Generate a latent tree
adjmat = makeModel(graphm, m);
if(strcmp(graphm,'5cayley')) % Observe the root node of the 5-cayley tree
    adjmat = [[0; adjmat(1:end-1,end)], [adjmat(end,1:end-1); adjmat(1:end-1,1:end-1)]]; 
    m = m+1;
end
%G=graph(full(adjmat)~=0);
%plot(G);
topo_distance_org = treeDistance(adjmat);
topo_distance_org = topo_distance_org(1:m,1:m);
tree_partition_org = treePartition(adjmat,0,m);
ind = logical(tree_partition_org(:,m));
tree_partition_org(ind,:) = ~tree_partition_org(ind,:);

%parameter setting
d=3;
[p,~]=size(adjmat);
[root,~]=size(adjmat);
rho=0.94;
temp=randn(d,d);
Sigma_r=2*temp*temp.'+eye(d);
[V,D]=eig(Sigma_r);
LambdaA=diag([rho,0.98*rho,0.97*rho]);
Lambdan=D-LambdaA*D*LambdaA;
A=V*LambdaA*V.';
Sigma_n=V*Lambdan*V.';
delta_g=exp(log(det(A*A.')));
delta_d=-0.5*log(det(A*A.'));


num_samples = length(nset);
num_recov1=zeros(num_runs,num_samples);
num_recov2=zeros(num_runs,num_samples);
num_recov3=zeros(num_runs,num_samples);
num_recov4=zeros(num_runs,num_samples);
num_recov5=zeros(num_runs,num_samples);
num_recov6=zeros(num_runs,num_samples);
num_recov7=zeros(num_runs,num_samples);
num_recov8=zeros(num_runs,num_samples);
RFdistance1=zeros(num_runs,num_samples);
RFdistance2=zeros(num_runs,num_samples);
RFdistance3=zeros(num_runs,num_samples);
RFdistance4=zeros(num_runs,num_samples);
RFdistance5=zeros(num_runs,num_samples);
RFdistance6=zeros(num_runs,num_samples);
RFdistance7=zeros(num_runs,num_samples);
RFdistance8=zeros(num_runs,num_samples);
num_hidden1=zeros(num_runs,num_samples);
num_hidden2=zeros(num_runs,num_samples);
num_hidden3=zeros(num_runs,num_samples);
num_hidden4=zeros(num_runs,num_samples);
num_hidden5=zeros(num_runs,num_samples);
num_hidden6=zeros(num_runs,num_samples);
num_hidden7=zeros(num_runs,num_samples);
num_hidden8=zeros(num_runs,num_samples);
time1=zeros(num_runs,num_samples);
time2=zeros(num_runs,num_samples);
time3=zeros(num_runs,num_samples);
time4=zeros(num_runs,num_samples);
time5=zeros(num_runs,num_samples);
time6=zeros(num_runs,num_samples);
time7=zeros(num_runs,num_samples);
time8=zeros(num_runs,num_samples);


for r = 1:num_runs
    X=samplegeneimprv(adjmat,root,A,Sigma_r,Sigma_n,m,nset(1));
    noise='indeplargenoise';
    %noise='indepGaussian';
    %noise='constnoise';
    %noise='hmm';
    %noise='doublebinary';
    %noise='outlierGaussian';
    %noise='outlierhmm';
    %noise='outlierdb';
    
    
    maxnoise=60;
    X=addnoise(m,d,X,noise,maxnoise,n1);
    
    for np=1:num_samples    
        n = nset(np);
        fprintf('Running for samples %dK\n',n/1000);   
        
        if(np~=1)
            X_temp=samplegeneimprv(adjmat,root,A,Sigma_r,Sigma_n,m,(nset(np)-nset(np-1)));
            X=[X;X_temp];
        end
        %X=samplegeneration(adjmat,root,A,Sigma_r,Sigma_n,m,n);
        
        sample_distance1=distancecomputing(X,m,d,n1);
        sample_distance2=distancecomputing(X,m,d,0);
        %{
        trdist=truedist(adjmat,A,Sigma_r,m);
        error_dist=sample_distance-trdist;
        if(max(max(abs(error_dist)))<delta_d/2)
            print('sufficient');
        end
        %}
        tic;
        [adjmatT1,~] = RG(sample_distance1, useDistances, n);
        t1 = toc; 
        [is_exact, pes] = isExactRecovery(adjmatT1, topo_distance_org);
        tree_partition = treePartition(adjmatT1,0,m);
        ind = logical(tree_partition(:,m));
        tree_partition(ind,:) = ~tree_partition(ind,:);
        RF_distance1 = sum(~ismember(tree_partition_org, tree_partition, 'rows'));
        RF_distance2 = sum(~ismember(tree_partition, tree_partition_org, 'rows'));
        RFdistance1(r,np) = RF_distance1+RF_distance2;
        num_recov1(r,np) = is_exact;     
        num_hidden1(r,np) = size(adjmatT1,1) - m;
        time1(r,np)=t1;
        
        tic;
        adjmatT2 = SNJ(sample_distance1, useDistances,n);
        t2 = toc; 
        [is_exact, pes] = isExactRecovery(adjmatT2, topo_distance_org);
        tree_partition = treePartition(adjmatT2,0,m);
        ind = logical(tree_partition(:,m));
        tree_partition(ind,:) = ~tree_partition(ind,:);
        RF_distance1 = sum(~ismember(tree_partition_org, tree_partition, 'rows'));
        RF_distance2 = sum(~ismember(tree_partition, tree_partition_org, 'rows'));
        RFdistance2(r,np) = RF_distance1+RF_distance2;
        num_recov2(r,np) = is_exact;     
        num_hidden2(r,np) = size(adjmatT2,1) - m;
        time2(r,np)=t2;
        
        tic;
        [adjmatT3,~] = CLRG(sample_distance1, useDistances, n);
        t3 = toc; 
        [is_exact, pes] = isExactRecovery(adjmatT3, topo_distance_org);
        tree_partition = treePartition(adjmatT3,0,m);
        ind = logical(tree_partition(:,m));
        tree_partition(ind,:) = ~tree_partition(ind,:);
        RF_distance1 = sum(~ismember(tree_partition_org, tree_partition, 'rows'));
        RF_distance2 = sum(~ismember(tree_partition, tree_partition_org, 'rows'));
        RFdistance3(r,np) = RF_distance1+RF_distance2;
        num_recov3(r,np) = is_exact;     
        num_hidden3(r,np) = size(adjmatT3,1) - m;
        time3(r,np)=t3;
        
        tic;
        [adjmatT4,~] = NJ(sample_distance1, useDistances);
        t4 = toc; 
        [is_exact, pes] = isExactRecovery(adjmatT4, topo_distance_org);
        tree_partition = treePartition(adjmatT4,0,m);
        ind = logical(tree_partition(:,m));
        tree_partition(ind,:) = ~tree_partition(ind,:);
        RF_distance1 = sum(~ismember(tree_partition_org, tree_partition, 'rows'));
        RF_distance2 = sum(~ismember(tree_partition, tree_partition_org, 'rows'));
        RFdistance4(r,np) = RF_distance1+RF_distance2;
        num_recov4(r,np) = is_exact;     
        num_hidden4(r,np) = size(adjmatT4,1) - m;
        time4(r,np)=t4;
        
        [adjmatT5,~] = RG(sample_distance2, useDistances, n);
        t5 = toc; 
        [is_exact, pes] = isExactRecovery(adjmatT5, topo_distance_org);
        tree_partition = treePartition(adjmatT5,0,m);
        ind = logical(tree_partition(:,m));
        tree_partition(ind,:) = ~tree_partition(ind,:);
        RF_distance1 = sum(~ismember(tree_partition_org, tree_partition, 'rows'));
        RF_distance2 = sum(~ismember(tree_partition, tree_partition_org, 'rows'));
        RFdistance5(r,np) = RF_distance1+RF_distance2;
        num_recov5(r,np) = is_exact;     
        num_hidden5(r,np) = size(adjmatT5,1) - m;
        time5(r,np)=t5;
        
        tic;
        adjmatT6 = SNJ(sample_distance2, useDistances,n);
        t6 = toc; 
        [is_exact, pes] = isExactRecovery(adjmatT6, topo_distance_org);
        tree_partition = treePartition(adjmatT6,0,m);
        ind = logical(tree_partition(:,m));
        tree_partition(ind,:) = ~tree_partition(ind,:);
        RF_distance1 = sum(~ismember(tree_partition_org, tree_partition, 'rows'));
        RF_distance2 = sum(~ismember(tree_partition, tree_partition_org, 'rows'));
        RFdistance6(r,np) = RF_distance1+RF_distance2;
        num_recov6(r,np) = is_exact;     
        num_hidden6(r,np) = size(adjmatT6,1) - m;
        time6(r,np)=t6;
        
        tic;
        [adjmatT7,~] = CLRG(sample_distance2, useDistances, n);
        t7 = toc; 
        [is_exact, pes] = isExactRecovery(adjmatT7, topo_distance_org);
        tree_partition = treePartition(adjmatT7,0,m);
        ind = logical(tree_partition(:,m));
        tree_partition(ind,:) = ~tree_partition(ind,:);
        RF_distance1 = sum(~ismember(tree_partition_org, tree_partition, 'rows'));
        RF_distance2 = sum(~ismember(tree_partition, tree_partition_org, 'rows'));
        RFdistance7(r,np) = RF_distance1+RF_distance2;
        num_recov7(r,np) = is_exact;     
        num_hidden7(r,np) = size(adjmatT7,1) - m;
        time7(r,np)=t7;
        
        tic;
        [adjmatT8,~] = NJ(sample_distance2, useDistances);
        t8 = toc; 
        [is_exact, pes] = isExactRecovery(adjmatT8, topo_distance_org);
        tree_partition = treePartition(adjmatT8,0,m);
        ind = logical(tree_partition(:,m));
        tree_partition(ind,:) = ~tree_partition(ind,:);
        RF_distance1 = sum(~ismember(tree_partition_org, tree_partition, 'rows'));
        RF_distance2 = sum(~ismember(tree_partition, tree_partition_org, 'rows'));
        RFdistance8(r,np) = RF_distance1+RF_distance2;
        num_recov8(r,np) = is_exact;     
        num_hidden8(r,np) = size(adjmatT8,1) - m;
        time8(r,np)=t8;
        
    end
end


save('hmm_indeplarge2.mat');

%{
if(save_result)
    file_name = ['./results/' graph '_' num2str(m)]
    save(file_name);
end
%}
