function adjmat=SNJ(stats,useDistances,numSamples)

if (useDistances)
    distance = stats;
else
    samples = stats;
    numSamples = size(samples,2);
    prob_bij = computeBnStats(samples);
    distance = computeDistance(prob_bij);
end

m=size(distance,1);
nodeSet=cell(m,1);
indextable=[(1:m).' (1:m).'];
adjmat=zeros(m,m);
Fullset=1:m;
for i=1:m
    nodeSet{i,1}=i;
end
len_nodeSet=m;
R=exp(-distance);
Lambda_org=nan(m,m);
for i=1:m-1
    for j=i+1:m
        Rtemp=union(nodeSet{i,1},nodeSet{j,1});
        Rc=setdiff(Fullset,Rtemp);
        [~,S,~]=svd(R(Rtemp,Rc));
        S=diag(S);
        S=sort(S,'descend');
        Lambda_org(i,j)=S(2);
        Lambda_org(j,i)=Lambda_org(i,j);
    end
end
Lambda_org(logical(eye(m)))=inf;
Lambda=Lambda_org;

while(len_nodeSet>1)
    if(len_nodeSet==2)
        l_index=find(indextable(:,2)==1);
        r_index=find(indextable(:,2)==2);
        adjmat(l_index,r_index)=1;
        adjmat(r_index,l_index)=1;
        break;
    end
    [left,right]=find(Lambda==min(min(Lambda)));
    left=left(1);
    right=right(1);
    if(left>right)
        temp=left;
        left=right;
        right=temp;
    end
    vari_num=length(indextable);%%
    l_index=find(indextable(:,2)==left);
    r_index=find(indextable(:,2)==right);
    indextable=[indextable;vari_num+1 left];
    indextable(l_index,2)=0;
    indextable(r_index,2)=0;
    index_update=logical(indextable(:,2)>right);
    indextable(index_update,2)=indextable(index_update,2)-ones(sum(index_update),1);
    adjmat=[adjmat;zeros(1,vari_num)];
    adjmat=[adjmat zeros(vari_num+1,1)];
    adjmat(l_index,vari_num+1)=1;
    adjmat(vari_num+1,l_index)=1;
    adjmat(r_index,vari_num+1)=1;
    adjmat(vari_num+1,r_index)=1;
    
    nodeSet{left,1}=union(nodeSet{left,1},nodeSet{right,1});
    for i=right:len_nodeSet-1
        nodeSet{i,1}=nodeSet{i+1,1};
    end
    new_index=setdiff(1:len_nodeSet,right);
    Lambda=Lambda(new_index,new_index);
    len_nodeSet=len_nodeSet-1;
    for i=1:len_nodeSet
        Rtemp=union(nodeSet{i,1},nodeSet{left,1});
        Rc=setdiff(Fullset,Rtemp);
        [~,S,~]=svd(R(Rtemp,Rc));
        S=diag(S);
        S=sort(S,'descend');
        if(length(S)>=2)
            Lambda(left,i)=S(2);
            Lambda(i,left)=S(2);
        else
            Lambda(left,i)=0;
            Lambda(i,left)=0;
        end
    end
    Lambda(left,left)=inf;
    %Lambda=Lambda(1:len_nodeSet,1:len_nodeSet);
end
    
    
    
    
    
    
    
    
    
    
    
    




