function adjmat=clascNJ(stats,useDistances,numSamples)

if (useDistances)
    distance = stats;
else
    samples = stats;
    numSamples = size(samples,2);
    prob_bij = computeBnStats(samples);
    distance = computeDistance(prob_bij);
end

m=size(distance,1);
indextable=[(1:m).' (1:m).'];
len_node=m;
adjmat=zeros(m,m);
Q=nan(m,m);
for i=1:m
    for j=i+1:m
        Q(i,j)=m*distance(i,j)-sum(distance(:,i))-sum(distance(:,j));
        Q(j,i)=Q(i,j);
    end
end
Q(logical(eye(m)))=inf;

while(len_node>1)
    if(len_node==2)
        l_index=find(indextable(:,2)==1);
        r_index=find(indextable(:,2)==2);
        adjmat(l_index,r_index)=1;
        adjmat(r_index,l_index)=1;
        break;
    end
    [left,right]=find(Q==min(min(Q)));
    left=left(1);
    right=right(1);
    if(left>right)
        temp=left;
        left=right;
        right=temp;
    end
    vari_num=length(indextable);%%
    l_index=find(indextable(:,2)==left);
    r_index=find(indextable(:,2)==right);
    indextable=[indextable;vari_num+1 left];
    indextable(l_index,2)=0;
    indextable(r_index,2)=0;
    index_update=logical(indextable(:,2)>right);
    indextable(index_update,2)=indextable(index_update,2)-ones(sum(index_update),1);
    adjmat=[adjmat;zeros(1,vari_num)];
    adjmat=[adjmat zeros(vari_num+1,1)];
    adjmat(l_index,vari_num+1)=1;
    adjmat(vari_num+1,l_index)=1;
    adjmat(r_index,vari_num+1)=1;
    adjmat(vari_num+1,r_index)=1;
    for i=1:len_node
        Q(i,left)=0.5*(Q(i,left)+Q(i,right));
        Q(left,i)=Q(i,left);
    end
    new_index=setdiff(1:len_node,right);
    Q=Q(new_index,new_index);
    len_node=len_node-1;
    
    
end
