import argparse
import os
import subprocess
import torch

def main():
    """
    Run the complete pipeline:
    1. Generate datasets for dimensions 3, 10, and 50
    2. Train CFM and SBM models on the generated datasets
    """
    # Parse arguments
    parser = argparse.ArgumentParser(description='Run the complete pipeline')
    parser.add_argument('--dimensions', type=int, nargs='+', default=[3, 10, 50], 
                        help='Dimensions to process')
    parser.add_argument('--device', type=str, default="cuda" if torch.cuda.is_available() else "cpu", 
                        help='Device to use for training (cuda or cpu)')
    args = parser.parse_args()
    
    # Create main directories
    os.makedirs("folder_generate_table/datasets", exist_ok=True)
    os.makedirs("folder_generate_table/models", exist_ok=True)
    os.makedirs("folder_generate_table/results", exist_ok=True)
    
    # Step 1: Generate datasets
    print("Step 1: Generating datasets...")
    cmd = ["python", "folder_generate_table/generate_datasets.py", 
           "--dimensions"] + [str(dim) for dim in args.dimensions] + ["--device", args.device]
    subprocess.run(cmd, check=True)
    
    # Step 2: Train models
    print("Step 2: Training models...")
    cmd = ["python", "folder_generate_table/train_models.py", 
           "--dimensions"] + [str(dim) for dim in args.dimensions] + ["--device", args.device]
    subprocess.run(cmd, check=True)
    
    print("Pipeline completed successfully!")

if __name__ == "__main__":
    main()
