from Algorithms.Common.workflow_common import BaseWorkflow
from Algorithms.NovelD.brain_noveld import BrainNovelD
from Algorithms.NovelD.brain_noveld import NovelDWorkflowController
from Algorithms.NovelD.config_noveld import NovelDConfig

def run_workers(worker, conn):
    worker.step(conn)

class NovelDWorkflow(BaseWorkflow):
    desc:str="NovelD-"
    brain:BrainNovelD
    config:NovelDConfig
    wf_controller:NovelDWorkflowController

    def init_wf_controller(self):
        self.wf_controller = NovelDWorkflowController(self.config)

    def get_brain_cls(self):
        return BrainNovelD


def main_noveld(config:NovelDConfig):
    WF=NovelDWorkflow(config)
    WF.run()