from Algorithms.Common.workflow_common import BaseWorkflow
from Algorithms.RND.brain_rnd import BrainRND
from Algorithms.RND.brain_rnd import RNDWorkflowController
from Algorithms.RND.config_rnd import RNDConfig



def run_workers(worker, conn):
    worker.step(conn)


class RNDWorkFlow(BaseWorkflow):
    desc: str = "RND-"
    brain: BrainRND
    config: RNDConfig
    wf_controller: RNDWorkflowController

    def init_wf_controller(self):
        self.wf_controller = RNDWorkflowController(self.config)

    def get_brain_cls(self):
        return BrainRND


def main_rnd(config:RNDConfig):
    WF=RNDWorkFlow(config)
    WF.run()
