# SLA-v3: Spatial Linkability-Aware and Novelty-Encouraging State Heuristic for Exploration

This repository presents the implementation of **SLA-v3**, a novel intrinsic motivation approach that addresses the detachment-derailment problem through state traversal difficulty assessment. SLA-v3 can achieve 100000+ score in PitFall! with domain knowledge integration. More details can be found in the main paper and the appendix. The  major components for SLA-v3 can be found at `Algorithms/Slav3/`.

## Installation

```bash
conda create -n slaenv37 python=3.7
conda activate slaenv37
pip install -r requirements.txt
pip install torch==1.13.1+cu117 torchvision==0.14.1+cu117 torchaudio==0.13.1 --extra-index-url https://download.pytorch.org/whl/cu117
python -m atari_py.import_roms env_packages/Roms
cd env_packages/gym-minigrid/
pip install -e .

```

## Run SLA-v3
Configuration files (.yaml) containing the hyperparameter settings for MiniGrid-MultiRoom-N7S8 and PitFall! environments are provided in Algorithm/Slav3/cfg/. These configuration files serve as templates for running the experiments. To adapt the implementation to other environments, please modify the corresponding parameters in these configuration files.
### Minigrid
```bash
python scripts/run_slav3_minigrid.sh
```

### PitFall!
Researchers interested in tackling the challenging PitFall! environment are strongly encouraged to execute this script. For hardware, we recommend an NVIDIA RTX 4090 GPU (5GB memory utilization) and 10 processes of AMD EPYC 7763 64-core CPUs. Under this configuration, initial extrinsic rewards typically appear within the first 48 hours, with full experiment completion in about 10 days.
```bash
python scripts/run_slav3_pitfall.sh
```



