The verification experiments rely on installing Marabou and ERAN.

# Install Marabou
* Checkout commit 5fe8eab67884516a482a600445c870eac530045b
* Follow the install instructions on the marabou page but note:
  * During install with Make/CMake, OpenBlas may not get install correctly. In that case the install process fails and an expressive error is shown. 
  * To fix that, you need to trigger the install of the already downloaded openblas in the marabou directory manually, providing information about your CPU architecture. Again, do this only if cmake fails in the first round using the command:
    * `make TARGET=NEHALEM` in the directory Marabou/tools/OpenBLAS-0.3.19
  * Then retrigger cmake as before - this should run now.
* Then, you need to apply the patch in this directory to Marabou to fix issue [751](https://github.com/NeuralNetworkVerification/Marabou/issues/751)


# Install ERAN
* Checkout commit 8771d3158b2c64a360d5bdfd4433490863257dd6
* Install ERAN according to the official instructions
* Apply the patch ./Environment/eran.patch that contains a bugfix and the experimental setup


# Run Experiments
* The verification using abstract interpretation can be run using the __main__.py script in the tf_verify directory in ERAN with the preprocessed networks using the parameters
--netname ../path/to/onnx --zonotope ./zonotope.txt --output_constraints ./max_constraint.txt --domain deepzono --input_box ./empty_file.txt --debug true
 * Own networks can be created by first training a flow, using the scripts in ./Environment/Scripts to (1) train a classifier using "ClassifierTrain.py" and (2) Merge the flow and the classifier using "onnx_native_merger.py"

* For the experiments using deductive verification tool Marabou, unzip "USFlows-verification.zip" and run the "run-experiment.py" python file with the arguments:
--config ../experiments/verification/radial_in_distribution.yaml --report_dir=reports
and ensure that the configurations in radial_in_distribution.yaml point to the desired classifier/flow model.



