import numpy as np
import gurobipy as gp
from gurobipy import GRB

def solve_LP(c, A, b, G, h):
    rowSizeA = A.shape[0]
    rowSizeG = G.shape[0]
    c = c.tolist()
    A = A.tolist()
    b = b.tolist()
    G = G.tolist()
    h = h.tolist()
    
    decision_num = np.size(c)
    m = gp.Model()
    m.setParam('OutputFlag', 0)
    x = m.addVars(decision_num, vtype=GRB.CONTINUOUS, name='x')

    OBJ = x.prod(c)
    m.setObjective(OBJ, GRB.MINIMIZE)

    for i in range(rowSizeA):
        m.addConstr(x.prod(A[i]) == b[i])
    for j in range(rowSizeG):
        m.addConstr(x.prod(G[j]) <= h[j])

    m.optimize()
    sol = np.zeros(decision_num)
    objective = m.OBJ
#    print(objective)
    try:
        for i in range(decision_num):
            sol[i] = x[i].x
        print(sol)
    except:
        print("cannot solve")
        m.computeIIS()
        m.write('model.ilp')

    return sol
#
#c = np.loadtxt("c.txt")
#A = np.loadtxt("A.txt")
#b = np.loadtxt("b.txt")
#G = np.loadtxt("G.txt")
#h = np.loadtxt("h.txt")
#sol = solve_LP(c,A,b,G,h)
