# EWC-LoRA



## Requisite

This code is implemented in PyTorch, under the following environment settings:

- python = 3.8
- torch = 1.11.0
- torchvision = 0.12.1
- timm = 0.6.7


## Install

You can set up the environment using the provided `environment.yaml` file:

```bash
conda env create -f environment.yaml
```

Or install manually:

```bash
conda create -n ewclora python=3.8 pytorch=1.11.0 torchvision=0.12.0 -c pytorch
conda activate ewclora
pip install six ipdb scipy scikit-learn pyyaml tqdm tensorboard timm==0.6.7
```


## Training

All experiments were validated on 2 Quadro RTX 6000 GPUs (24GB each).

### Quick Start

Run a quick experiment with:
```bash
python main.py --device [your_device] --config configs/cifar100.json
```
The CIFAR-100 dataset will be automatically downloaded if not present.


(Optional) Disable Checkpoints: You can skip saving checkpoints by adding the `--no_ckp` flag:
```bash
python main.py --device 0,1 --config configs/cifar100.json --no_ckp
```
This will only produce output logs without saving model checkpoints.


## Dataset

- CIFAR-100: will be downloaded automatically

- DomainNet: download dataset from https://ai.bu.edu/M3SDA/

- ImageNet-R: download dataset from https://people.eecs.berkeley.edu/~hendrycks/imagenet-r.tar

- ImageNer-A: download dataset from https://people.eecs.berkeley.edu/~hendrycks/imagenet-a.tar

The dataset path can be modified in the configuration file.
