<h1 align='center'> Neural SDEs Made Easy:<br>SDEs are Infinite-Dimensional GANs<br><a href="redacted">[arXiv]</a></h1>

We observe that the mathematics of SDEs aligns perfectly with the machine learning with GANs. By making this connection, we get a natural, straightforward way to learn neural SDEs, as _generative time series models_.

+ Arbitrary drift and diffusions are admissible, and in the infinite data limit any SDE may be learnt.
+ We expect this to be particularly useful for the sorts of problems non-neural SDEs are already useful for - physics, finance and so on.
+ Easy to implement with existing tools.

We also make some technical contributions: better ways to simulate Brownian motion, and better proofs of the adjoint equations (used for backpropagation).

---

# Paper
The paper can be found [here]([redacted]).

# Code
### Requirements
Python 3.8  
PyTorch 1.6  
torchcde 0.1.0  
torchvision 0.7.0  
tqdm  4.50.0  
pandas 1.1.2  
Signatory 1.2.3.1.6.0

Plus the bundled torchsde library.

In summary:
```bash
conda install -c pytorch pytorch==1.6.0 torchvision==0.7.0
pip install git+https://github.com/patrick-kidger/torchcde.git
pip install tqdm==4.50.0
pip install signatory==1.2.3.1.6.0 --no-cache-dir --force-reinstall
pip install pandas==1.1.2
cd torchsde
python setup.py install
```

### Reproducing experiments:
Air quality:

```python
>>> import air_quality
>>> results = air_quality.default(<device>, <model>)
>>> print(results.keys())  # inspect results object
>>> print(results.evaluate.mmd_loss)  # query results object
```

where `<device>` is a device as recognised by PyTorch, and <model> is one of `'nsde'`, `'latent_ode'`, `'ctfp'`.

Weights, stocks: substitute `air_quality` for either `weights` or `stocks`.

Additionally, results will be saved to the `results/` folder.