from .ctfp import CTFP
from .latent_ode import LatentODE
from .ncde import NeuralCDE
from .node import NeuralODE
from .nsde import NeuralSDE
from .seq2seq import Seq2Seq


def make_model(model_name, **kwargs):
    if model_name == 'nsde':
        return NeuralSDE(**kwargs)
    elif model_name == 'latent_ode':
        return LatentODE(**kwargs)
    elif model_name == 'ctfp':
        return CTFP(**kwargs)
    else:
        raise ValueError
