#ifndef BROWNIAN_PATH_HPP
#define BROWNIAN_PATH_HPP

#include <torch/torch.h>

#include <map>

class BrownianPath {
 private:
  std::map<double, torch::Tensor> cache;

 public:
  BrownianPath(double t0, torch::Tensor w0);

  BrownianPath(std::map<double, torch::Tensor> data);

  torch::Tensor call(double t);

  void insert(double t, torch::Tensor w);

  std::string repr() const;

  std::map<double, torch::Tensor> get_cache() const;

  double get_t_head() const;

  double get_t_tail() const;

  torch::Tensor get_w_head() const;

  torch::Tensor get_w_tail() const;
};

#endif
