import abc

from .._core import better_abc


class BaseBrownian(metaclass=better_abc.ABCMeta):
    @abc.abstractmethod
    def __call__(self, ta, tb, return_U=False, return_A=False):
        raise NotImplementedError

    @abc.abstractmethod
    def __repr__(self):
        raise NotImplementedError

    @abc.abstractmethod
    def to(self, *args, **kwargs):
        raise NotImplementedError

    dtype = better_abc.abstract_attribute()
    device = better_abc.abstract_attribute()
    shape = better_abc.abstract_attribute()
    levy_area_approximation = better_abc.abstract_attribute()

    def size(self):
        return self.shape
