# We import from `typing` more than what's enough, so that other modules can import from this file and not `typing`.
from typing import Sequence, Union, Optional, Any, Dict, Tuple, Callable

import torch

Tensor = torch.Tensor
Tensors = Sequence[Tensor]
TensorOrTensors = Union[Tensor, Tensors]

Scalar = Union[float, Tensor]
Vector = Union[Sequence[float], Tensor]

Module = torch.nn.Module
Modules = Sequence[Module]
ModuleOrModules = Union[Module, Modules]
