#!/apps/anaconda3/bin/python
# coding: utf-8


import pandas as pd
import numpy as np
from the_setting_class import Setting

num_points = 20

np.random.seed(42)

# n_values = np.logspace(1, 4, num_points, dtype = int)
# n_values = np.logspace(4, 5, 4, dtype = int)[1:]
# result_filename = "log_grid_large_n"

n_values = np.linspace(10, int(1e4), num_points, dtype = int)
# n_values = np.linspace(10, int(1e3), num_points, dtype = int)
result_filename = "finite_mean_only_fixed_seed"
# n_values = np.linspace(10, int(1e5), num_points, dtype = int)[1:] + int(1e3)
# result_filename = "finite_variance_medium"
print(n_values)

num_trials = int(1e6)
# eps = 0.1
eps = 0.01

tail_quantile_fn = lambda y: y/(np.log(1+y)**(1+eps))
# tail_quantile_fn = lambda y: np.sqrt(y/(np.log(1+y)**(1+eps)))

experiment_setting = Setting(
    n_values=n_values,
    num_trials=num_trials,
    tail_quantile_fn=tail_quantile_fn,
    # normalization=None,
    result_filename=result_filename,
    # Fplus=True,
)

experiment_setting.run_trials()
