import numpy as np
import os, pdb, sys


def generate_mkp_ilp(n_items, m_knapsacks, seed=None):
    if seed is not None:
        random.seed(seed)
        np.random.seed(seed)

    # Generate random profits and weights
    profits = np.random.randint(10, 100, size=n_items)
    weights = np.random.randint(5, 30, size=n_items)
    capacities = np.random.randint(n_items * 5 // m_knapsacks, n_items * 10 // m_knapsacks, size=m_knapsacks)

    # Number of variables: x_ij for each item i and knapsack j
    num_vars = n_items * m_knapsacks
    c = np.zeros(num_vars, dtype=int)

    def idx(i, j):
        return i * m_knapsacks + j

    # Objective coefficients
    for i in range(n_items):
        for j in range(m_knapsacks):
            c[idx(i, j)] = profits[i]

    A = []
    b = []

    # 1. Assignment constraints: each item in at most one knapsack
    for i in range(n_items):
        row = np.zeros(num_vars, dtype=int)
        for j in range(m_knapsacks):
            row[idx(i, j)] = 1
        A.append(row)
        b.append(1)

    # 2. Capacity constraints: each knapsack can't exceed its capacity
    for j in range(m_knapsacks):
        row = np.zeros(num_vars, dtype=int)
        for i in range(n_items):
            row[idx(i, j)] = weights[i]
        A.append(row)
        b.append(capacities[j])

    # 3. Bounds: x_ij ∈ {0,1} enforced via inequalities
    for i in range(n_items):
        for j in range(m_knapsacks):
            k = idx(i, j)
            # x_ij ≤ 1
            row = np.zeros(num_vars, dtype=int)
            row[k] = 1
            A.append(row)
            b.append(1)

            # -x_ij ≤ 0 → x_ij ≥ 0
            row = np.zeros(num_vars, dtype=int)
            row[k] = -1
            A.append(row)
            b.append(0)

    A = np.array(A, dtype=int)
    b = np.array(b, dtype=int)

    return A, b, c

if __name__ == "__main__":

    #nb_facilities = 20
    #nb_customers = 20

    #A, b, c  = generateMatrices(nb_customers, nb_facilities, max_demand_per_customer, min_price, max_price, max_cost)
    #print("c")
    #print(b)
    #print("b")
    #print(-c)
    #print("A")
    #print(-A.transpose())
    ##pdb.set_trace()

    nb_customers = int(sys.argv[1])
    nb_facilities = int(sys.argv[2])
    nb_samples = int(sys.argv[3])

    prefix = "."
    pathset = f"{prefix}/knapsack_{nb_customers}_{nb_facilities}_num{nb_samples}/"
    if not(os.path.exists(pathset)):
        os.mkdir(pathset)
    
    for i in range(nb_samples):
        print(i)
        A, b, c = generate_mkp_ilp(nb_customers, nb_facilities)
        #pdb.set_trace()
        np.save(f"{prefix}/knapsack_{nb_customers}_{nb_facilities}_num{nb_samples}/knapsack_ip_data_{i}.npy", {'A': A, 'c': c, 'b': b})

