import numpy as np
import os, pdb, sys
from IP import *
import networkx as nx
import random


def generate_vertex_cover_ilp(n, m, seed=None):
    if seed is not None:
        random.seed(seed)
        np.random.seed(seed)

    # Generate all possible edges (i < j, undirected)
    possible_edges = [(i, j) for i in range(n) for j in range(i + 1, n)]
    if m > len(possible_edges):
        raise ValueError("Too many edges for a simple graph.")

    edges = random.sample(possible_edges, m)

    # Number of variables: one per vertex
    num_vars = n

    # Edge constraints: -x_u - x_v ≤ -1
    A_edge = np.zeros((m, n), dtype=int)
    for idx, (u, v) in enumerate(edges):
        A_edge[idx, u] = -1
        A_edge[idx, v] = -1
    b_edge = -np.ones(m, dtype=int)

    # Upper bounds: x_v ≤ 1
    A_ub = np.eye(n, dtype=int)
    b_ub = np.ones(n, dtype=int)

    # Lower bounds: -x_v ≤ 0  ⇒ x_v ≥ 0
    A_lb = -np.eye(n, dtype=int)
    b_lb = np.zeros(n, dtype=int)

    # Combine all constraints
    A = np.vstack([A_edge, A_ub, A_lb])
    b = np.concatenate([b_edge, b_ub, b_lb])

    # Objective: minimize sum x_v
    c = np.ones(n, dtype=int)

    return A, b, c


if __name__ == "__main__":
    #Rows = generateSubsets(3, 6)
    #A,b,c = indicatorRowsToMatrixConstraint(Rows)


    #A_tmp = -A.transpose()                                                                                                
    #b_tmp = c                                                                                                             
    #c_tmp = -b


    #IPX = IP(A,c,b)
    #IPX.optimize()
    #print(np.array(get_simplex_tableau(A,c,b)).astype(float))
    #pdb.set_trace()


    prefix = "."
    nb_vertices = int(sys.argv[1])
    nb_edges = int(sys.argv[2])
    nb_samples = int(sys.argv[3])
    pathset = f"{prefix}/vertexcover_{nb_vertices}_{nb_edges}_num{nb_samples}/"
    if not(os.path.exists(pathset)):
        os.mkdir(pathset)

    for i in range(nb_samples):
        print(i)
        A,b,c = generate_vertex_cover_ilp(nb_vertices, nb_edges) 
        pdb.set_trace()
        #pdb.set_trace()
        np.save(f"/{prefix}/vertexcover_{nb_vertices}_{nb_edges}_num{nb_samples}/vertexcover_ip_data_{i}.npy", {'A':A, 'c': c, 'b': b})