### This is the demo code of our paper "Binarized Spectral Compressive Imaging" in submission to NeurIPS 2023

This repo includes:  

- Specification of dependencies
- Evaluation code for simulation scenes
- Evaluation code for real scenes
- Visualization code
- README file


This repor can reproduce the main results in Table 1, Figure 5, and Figure 6. All the source code and pre-trained weights will be made publicly available for further research.

------

### 1. Create Envirement:

- Python 3 (Recommend to use [Anaconda](https://www.anaconda.com/download/#linux))

- [PyTorch >= 1.3](https://pytorch.org/)

- NVIDIA GPU + [CUDA](https://developer.nvidia.com/cuda-downloads)

- Python packages:

  ```shell
  pip install -r requirements.txt
  ```


------

### 2. Prepare Dataset:

Download the dataset from https://github.com/mengziyi64/TSA-Net, put the dataset into the corresponding folder 'datasets/', and recollect them as the following form:

```
|--datasets   
  |--TSA_simu_data  
    |--mask.mat   
    |--Truth
      |--scene01.mat
      |--scene02.mat
      ： 
      |--scene10.mat
  |--TSA_real_data  
    |--mask.mat   
    |--Measurements
      |--scene1.mat
      |--scene2.mat
      ： 
      |--scene5.mat
```

------

### 3. Evaluation

#### 3. 1  Test our pre-trained BiSRNet on the simulation HSI dataset:

```shell
cd /code/simulation/test_code/
python test.py
```

Then get in 'code/simulation/Quality_Metrics/' and 

```shell
run Cal_quality_assessment.m
```
to calculate the PSNR and SSIM.


#### 3. 2  Test our pre-trained BiSRNet on the real HSI dataset:
```shell
cd /code/real/test_code/
python test.py
```

------

### 4. Visualization

#### 4.1 Visualize simulation reconstructed HSIs

Put the reconstruted HSIs in `/code/visualization/simulation_results/results/` and rename it as `BiSRNet.mat`. Then generate the RGB images of the reconstructed HSIs:

```shell
 cd /code/visualization/
 run show_simulation.m 
```

#### 4.2 Visualize real reconstructed HSIs

Put the reconstruted HSIs in `/code/visualization/real_results/results/` and rename it as `BiSRNet.mat`. Then generate the RGB images of the reconstructed HSIs:

```shell
 cd /code/visualization/
 run show_real.m 
```

### 5. Acknowledgement

This repo is mainly based on MST: `https://github.com/caiyuanhao1998/MST`. 

We thank this repo and have cited this paper in our manuscript.