# Marginal Tail-Adaptive Normalizing Flows
This repository contains the code for reproducing the empirical results in the paper.

## How to run the code
### Install required packages:
```
pip install -r requirements.txt
```

Then, navigate to the folder ``synthetic_experiments``: 
```
cd synthetic_experiments
```
### Run the Experiments from Section 4.1: Model Accuracy
Give execute permission to the script:
```
chmod +x run_marginal_tails.sh
```

The first 2 lines in ``run_marginal_tails.sh`` describe the investigated setting. These lines must be adjusted according to the setting. 

Run the script:
```
./run_marginal_tails.sh
```

The script runs 10 trials of the vanilla flow, TAF, TAF(nu_1,....nu_D), and mTAF. To run mTAF with fixed degrees of freedom, one can either run
```
python marginals_tails.py --marginals mTAF(fix)
``` 
or adjust the sh-script by replacing the ``mTAF`` by ``mTAF(fix)`` in line 5.

After each sweep of 10 trials in one settings, all results are saved in ``synthetic_experiments/results/likelihood`` and need to be cut into the folder associated with the setting. For instance, results of the experiment nu=2 and h=8 need to be moved from ``synthetic_experiments/results/likelihood`` to ``synthetic_experiments/df2h8/likelihood`` or to ``synthetic_experiments/df2h8/fix/likelihood`` if we move the results for mTAF(fix). 

When all experiments are executed (h=1,2,4,8 and nu=2,3), we can visualize the results by running 
```
python evaluation.py
```

### Run the Experiments from Section 4.2: Generating Tail Events
Here, we are reusing the learned models from above, which are saved in ``synthetic_experiments/models``.
Run
```
python sampling_tail.py
```
to generate Figure 2 and Figure 5. We can adjust the investigated setting from Figure 5 by setting the flags ``--df`` and ``--num_heavy`` according to the desired setting.

Run
```
python sampling_tail.py --plot vanillataf
```
to generate Figure 3. Again, we can set the flags ``--df`` and ``--num_heavy`` according to the desired setting.


## Additional Files
``utils`` contains helper files and scripts: 
``tail_estimation.py`` estimates marginal tail indices, 
``distributions.py`` contains implementations of base distributions,
``tail_permutation.py`` contains the implementation of our permutation scheme, 
``flows.py`` contains nsflows implementations of the flows.

``data_generators.py`` contains the implementation of the synthetic data generator.

