import torch
import spacy
from transformers import GPT2LMHeadModel, GPT2TokenizerFast

max_new_tokens = 1023
temperature = 1.0
batch_size = 200
seed = 42

if torch.cuda.is_available():
    device = torch.device("cuda")
    spacy.require_gpu()
else:
    device = torch.device("cpu")

torch.manual_seed(seed)

model = GPT2LMHeadModel.from_pretrained("gpt2").to(device)
tokenizer = GPT2TokenizerFast.from_pretrained("gpt2", padding_side="left")
nlp = spacy.load("en_core_web_sm")

input_ids = torch.tensor([[tokenizer.bos_token_id] for _ in range(batch_size)]).to(device)
attention_mask = torch.ones(input_ids.shape).to(device)

outputs = model.generate(
    input_ids,
    max_new_tokens=max_new_tokens,
    do_sample=True,
    top_k=0,
    temperature=temperature,
    attention_mask=attention_mask,
    eos_token_id=tokenizer.eos_token_id,
    pad_token_id=tokenizer.eos_token_id
)
texts = tokenizer.batch_decode(outputs, skip_special_tokens=True)
tagged = [ [ (token.text, token.pos_) for token in doc ] for doc in nlp.pipe(texts) ]