import pickle
import numpy as np

num_samples = 160000
N = 512
a = "PROPN"

with open("list_of_tagged_sequence.pkl", "rb") as f:
    list_of_tagged_sequence = pickle.load(f)

data_a = []
for tagged_sequence in list_of_tagged_sequence:
    if len(data_a) == num_samples:
        break
    if len(tagged_sequence) < N:
        continue
    data_a.append([POS == a for _, POS in tagged_sequence[:N:]])
data_a = np.array(data_a, dtype=bool)

fourier = np.fft.fft(data_a, axis=1)
power_spectrum = (np.mean(np.abs(fourier)**2, axis=0) - np.mean(np.abs(fourier), axis=0)**2) / N