## Code for "Fine-Tuning of Continuous Time Diffusion Models as Entropy Regularized Control"  

As per the policy of our affiliated organization, this version includes code solely for biological sequences. In the final release, we commit to providing code that encompasses images and uploading it to GitHub.

### Introduction

This repository comprises fundamental code for working with diffusion models on biological sequences, encompassing DNA and protein sequences.

### Summary 

* __model/fine_tune.py__: Contains code for methods such as ELEGANT, PPO, Truncation, Random, etc.
* __model/train_continuous_mode.py__: Includes code for obtaining a pre-trained diffusion model.
* __model/generate.py__: Contains code for generating samples from diffusion models.
* __model/sde.py__: Includes code for defining an SDE (Stochastic Differential Equation).
* __model/seq_net.py__: Contains code for defining transformer-based neural networks.
* __model/util.py__: Includes code for data processing.
* __feature/sequence_dataset.py__: Contains code for defining a data-loader.
* __feature/util.py__: Includes code for data pre-processing.

