<!-- TITLE -->
# **Fine-Tuning of Continuous-Time Diffusion Models as Entropy-Regularized Control**

<!-- ## Code -->
## Installation  

Create a conda environment with the following command:

```bash
conda create -n ELEGANT python=3.10
conda activate ELEGANT
pip install -r requirements.txt
```

Please use accelerate==0.17.0, other library dependancies might be flexible.

## Training

HuggingFace Accelerate will automatically handle parallel training.  
We conduct our experiments on image tasks using 4 A100 GPUs. Please adjust [*config.train.batch_size_per_gpu_available*] variable in config files according to your GPU memory.  

#### Running NO KL (Baseline)  

```bash
accelerate launch main.py --config config/align_prop.py:aesthetic --config.train.kl_weight 0.0
```

#### Running ELEGANT (alpha=5)  

```bash
accelerate launch fderc/main.py --config config/fderc_main.py:aesthetic --config.train.kl_weight 0.05
```

#### Running ELEGANT (alpha=10)  

```bash
accelerate launch fderc/main.py --config config/fderc_main.py:aesthetic --config.train.kl_weight 0.1
```

## Evaluation

#### Evaluate ELEGANT (alpha=5)

```bash
accelerate launch fderc/main.py --config config/fderc_main.py:evaluate --config.train.kl_weight 0.05 --config.resume_from $checkpoint_path --config.run_name Evaluation/FDERC-0.05/ckpt_$i
```  

#### Evaluate ELEGANT (alpha=10)

```bash
accelerate launch fderc/main.py --config config/fderc_main.py:evaluate --config.train.kl_weight 0.1 --config.resume_from $checkpoint_path --config.run_name Evaluation/FDERC-1e-1/ckpt_$i
```  
