import pandas as pd
from TTS.api import TTS
import os
from tqdm.auto import tqdm

df = pd.read_csv("./train_ENG.csv")

device = "cuda:1"
tts = TTS(model_name="tts_models/multilingual/multi-dataset/xtts_v2").to(device)

output_dir = 'tts'
os.makedirs(output_dir, exist_ok=True)

for index, row in tqdm(df.iterrows(), total=df.shape[0]):
    file_name = row['id']
    text = row['pronunciation']
    lang = "en" if row["language"] == "eng" else "ru"
    if lang == "ru":
        continue

    output_file = os.path.join(output_dir, f"audio_{file_name}.wav")

    if os.path.exists(output_file):
        print(f"{output_file} was skipped")
        continue

    tts.tts_to_file(text=text, file_path=output_file, speaker_wav='./g300.wav', language=lang)
