# Revisiting the Role of Homophily in Fair Graph Representation Learning

This repository contains the official implementation of our paper:  
**"Revisiting the Role of Homophily in Fair Graph Representation Learning"**  
Submitted to **ICLR 2026**.

## Environment

**Python**: 3.8.19

### Required Packages

Make sure to install the following dependencies:

```
numpy==1.24.4
torch==2.4.1
torch-geometric==2.5.3
torch-scatter==2.1.2
torch-sparse==0.6.18
```

## Run the codes

### CSBM-S Experiment (Figure 1)

We reproduce Figure 1 by evaluating node-classification accuracy, statistical parity (ΔSP), and equal opportunity (ΔEO) on CSBM-S graphs. The script below generates the graphs, trains the models, and logs the metrics used to render Figure 1. 

**Reproduction steps**

```
# move into the CSBM-S project directory
cd ./csbm_s

# run the experiment
python main_csbms.py
```

### FairEST Experiment (Table 1)

We reproduce Table 1 by evaluating node-classification accuracy, statistical parity (ΔSP), and equal opportunity (ΔEO) on real-world graph datasets. The script below trains the models and logs the metrics reported in Table 1. 

**Step 1: Copy Requird Files**

Copy the following files into the current working directory:

```
cp ./src/fairest.py .
cp ./scripts/fairest.sh .
```

**Step 2: Run Experiments**

Execute the shell scripts below to run the full set of experiments with all relevant hyperparameter settings:

```
bash fairest.sh
```

### Other Experiments

All experiments presented in the paper can be reproduced using the similar procedure described above. 

## Licenses

This project is licensed under CC BY 4.0. To view a copy of this license, please visit https://creativecommons.org/licenses/by/4.0/
