# Demo code for **Prototype-oriented Clustering with Distillation (PCD)**

### Prerequisites:
- python == 3.6.8
- cudatoolkit == 11.0
- pytorch ==1.7.1
- torchvision == 0.8.2
- numpy, scipy, sklearn, PIL, argparse, tqdm

### Demo:
1. Setup the environment and store the data under the folder `data`.

2. Run the following code to reproduce the result for the task $\mathcal{R} \rightarrow$ A on the Office-31 dataset for Resnet-18 backbone.

   - First stage (source model clustering)
     
     > python demo.py --gpu_id 0 --seed 2021 --output_src ./ckps/src_office31 --dset office --t 0 --da uda --net_src resnet18 --net resnet18 --max_epoch 50 

   - Second stage (target model clustering with distillation)
   
     > python demo.py --gpu_id 0 --seed 2021 --output_src ./ckps/src_office31 --dset office --t 0 --da uda --net_src resnet18 --max_epoch 30 --net resnet18 --output ./ckps/tar_office31 --distill --topk 1 
 
   - Third stage (target model refinement)
     
     > python demo_refinement.py --gpu_id 0 --seed 2021 --dset office --t 0 --da uda --net_src resnet18 --max_epoch 30 --net resnet18 --lr 1e-2 --output ./ckps/tar_office31

### Citation

We adapt our code from the following codebases:

[IIC](github.com/xu-ji/IIC) (MIT license)
> @inproceedings{ji2019invariant,  
> &nbsp; &nbsp;  title={Invariant information clustering for unsupervised image classification and segmentation},  
> &nbsp; &nbsp;  author={Ji, Xu and Henriques, Jo{\~a}o F and Vedaldi, Andrea},  
> &nbsp; &nbsp;  booktitle={Proceedings of the IEEE International Conference on Computer Vision},  
> &nbsp; &nbsp;  pages={9865--9874},  
> &nbsp; &nbsp;  year={2019}  
> }

[ACIDS](github.com/willi-menapace/acids-clustering-domain-shift) (MIT license)
> @inproceedings{menapace2020learning,  
>  &nbsp; &nbsp;  author    = {Willi Menapace and  
>  &nbsp; &nbsp;  St{\'{e}}phane Lathuili{\`{e}}re and  
>  &nbsp; &nbsp;  Elisa Ricci},  
>  &nbsp; &nbsp;  title     = {Learning to Cluster Under Domain Shift},  
>  &nbsp; &nbsp;  booktitle = {Computer Vision - {ECCV} 2020 - 16th European Conference, Glasgow,  
>  &nbsp; &nbsp;  UK, August 23-28, 2020, Proceedings, Part {XXVIII}},  
>  &nbsp; &nbsp;  series    = {Lecture Notes in Computer Science},  
>  &nbsp; &nbsp;  volume    = {12373},  
>  &nbsp; &nbsp;  pages     = {736--752},  
>  &nbsp; &nbsp;  publisher = {Springer},  
>  &nbsp; &nbsp;  year      = {2020}  
> }

[DINE](github.com/tim-learn/DINE/) (MIT license)
> @article{liang2021dine,  
> &nbsp; &nbsp;  title={DINE: Domain Adaptation from Single and Multiple Black-box Predictors},  
> &nbsp; &nbsp;  author={Liang, Jian and Hu, Dapeng and Feng, Jiashi and He, Ran},  
> &nbsp; &nbsp;  journal={arxiv preprint arXiv: 2104.01539V2},   
> &nbsp; &nbsp;  year={2021}  
> }

[SHOT](github.com/tim-learn/SHOT) (MIT license)
> @inproceedings{liang2020we,  
> &nbsp; &nbsp;  title={Do We Really Need to Access the Source Data? Source Hypothesis Transfer for Unsupervised  
> &nbsp; &nbsp;  Domain Adaptation},  
> &nbsp; &nbsp;  author={Liang, Jian and Hu, Dapeng and Feng, Jiashi},  
> &nbsp; &nbsp;  booktitle={International Conference on Machine Learning (ICML)},  
> &nbsp; &nbsp;  pages={6028--6039},  
> &nbsp; &nbsp;  year={2020}  
> }
