# Mol3DNet: Point_Based Molecular Representation Learning from Conformers



## Environment

```bash
conda create -n molnet
conda activate molnet
conda install pytorch torchvision torchaudio cudatoolkit=10.2 -c pytorch
conda install -c conda-forge rdkit tqdm pyyaml tensorboard
conda install -c anaconda scikit-learn
# for generate OMEGA conformers
conda install -c openeye openeye-toolkits
```



## Data preprocess

Please follow the steps `./DATA_PROCESS.md`. Our codes support $4$ datasets now. You could only process the dataset you want to use rather than all the datasets. 



## Regression & Classification Tasks

The complete running scripts are in `./experiments/`. 

```bash
# train regression tasks
python main_reg.py --config <path_to_configuration> \
--log_dir <path_to_log> \
--checkpoint <path_to_checkpoint> \
--resume_path <path_to_resume_checkpoint> \
--device 1 

# train classification tasks
python main_cls.py --config <path_to_configuration> \
--log_dir <path_to_log> \
--checkpoint <path_to_checkpoint> \
--resume_path <path_to_resume_checkpoint> \
--device 1 
```

