import os
import numpy as np
try:
    import sys
    sys.path.append('../convolutional_occupancy_networks/')
    from src.utils.libkdtree import KDTree
except:
    from scipy.spatial import KDTree

def compute_dist_square(vertices, vertices_gt):
    l2 = ((vertices - vertices_gt)**2).sum(-1)
    return l2.mean()


def normal_consistency(normals_src, normals_tgt):
    normals_src = normals_src / np.linalg.norm(normals_src, axis=-1, keepdims=True)
    normals_tgt = normals_tgt / np.linalg.norm(normals_tgt, axis=-1, keepdims=True)

    normals_dot_product = (normals_tgt * normals_src).sum(axis=-1)
    # Handle normals that point into wrong direction gracefully
    # (mostly due to mehtod not caring about this in generation)
    normals_dot_product = np.abs(normals_dot_product)
    
    return normals_dot_product.mean()

def chamfer_distance(points, points_gt):
    kdtree = KDTree(points_gt)
    compleness, idx = kdtree.query(points)
    kdtree = KDTree(points)
    accuracy, idx = kdtree.query(points_gt)
    chamfer_l1 = 0.5 * (accuracy.mean() + compleness.mean())
    
    return chamfer_l1