#!/usr/bin/zsh

# Experiments on ZINC
for seed in {0,1,2}; do
  for lr in {0.001,0.0003,0.0001}; do
    for layers in {1,2,4,8}; do
      for name in {ZINC-GCN,ZINC-GATv2,ZINC-GIN,ZINC-SAGE,ZINC-MC-GIN}; do
        config=configs/${name}.yaml
        args="--cfg=$config --repeat 1 gnn.dim_inner 700 optim.base_lr $lr seed $seed gnn.layers_mp $layers dataset.name full name_tag ${layers}_${lr}.%J"
        python main.py ${args}
      done
    done
  done
done