clear
clc
close all

rng(100)

% Parameters setting
d = 5000; % dimension
s = 20; % sparsity
beta = 100; % signal strength

%% Generate true spike vector
u = zeros(d,1); % u: true spike vector
T = randperm(d,s); % T: support of u
u_T = randn(s,1);
u_T(u_T >= 0) = 1;
u_T(u_T < 0) = -1;
u(T) = u_T/norm(u_T,2);

%% Generate noisy matrx Y = beta u u' + W
A = randn(d); 
Y = beta*(u*u') + (A + A')/sqrt(2);

%% Column thresholding
dist_col = solver_column_thresholding(u,Y,d,s);

%% Truncated power method (TPM)
k = s; % sparsity parameter for TPM
t_max = 1000; % maximum number of iterations for TPM
dist_TPM = solver_tpm(u,Y,d,s,k,t_max);





