function dist_col = solver_column_thresholding(u,Y,d,s)
% u: underlying signal, d*1
% Y: noisy matrix
% s: sparsity
% d: dimension

%% Construct \hat{T}_col
[~,i0] = max(diag(Y)); % Compute i0
Y_i0 = Y(:,i0);
[~, T_hat] = maxk(abs(Y_i0), s);
T_hat = sort(T_hat,'ascend');

%% Form Y_That and calculate u_hat
Y_That = Y(T_hat,T_hat);
[v, ~] = eigs(Y_That, 1, 'largestabs'); % v is the unit eigenvector correspoding to the largest eigenvalue of Y_That

u_hat = zeros(d,1);
u_hat(T_hat) = v; 

dist_col = min(norm(u-u_hat,2),norm(u+u_hat,2));

end

