function dist_TPM = solver_tpm(u,Y,d,s,k,t_max)
% u: underlying signal, d*1
% Y: noisy matrix
% s: sparsity
% d: dimension
% k: sparsity parameter for TPM
% t_max: maximum number of iterations for TPM


%% Initialization via column thresholding
% Construct \hat{T}_col
[~,i0] = max(diag(Y)); % Compute i0
Y_i0 = Y(:,i0);
[~, T_hat] = maxk(abs(Y_i0), s);
T_hat = sort(T_hat,'ascend');

% Form Y_That and calculate w0
Y_That = Y(T_hat,T_hat);
[v, ~] = eigs(Y_That, 1, 'largestabs'); % v is the unit eigenvector correspoding to the largest eigenvalue of Y_That

w0 = zeros(d,1);
w0(T_hat) = v; 


%% Truncated Power Iteration
for t = 1:t_max
   w = w0;
   T_w = find(abs(w)>0);
   w0 = Y(:,T_w)*w(T_w);
   w0 = truncation(w0,k); % keep the top k elements of w in abs.value and set others to be 0
   w0 = w0/norm(w0,2);
   if norm(w0-w,2) < 10^(-8)
      break;
   end
end

% Calculate u_hat = w0
dist_TPM = min(norm(u-w0,2),norm(u+w0,2)); % distance between u and u_hat

end

