# Neurodynamic Network Controller for CartPole using CMA-ES

This repository implements a compact E-I neurodynamic network controller trained using the CMA-ES evolutionary strategy to solve the CartPole-v1/MoJoCo reinforcement learning task.

## Overview

- Spiking neurons modeled using LIF dynamics (via `spiketorch`)
- Fully static synapses (non-plastic), optimized end-to-end
- Evolutionary optimization using [CMA-ES](https://github.com/CMA-ES/pycma)
- Compatible with SLURM-based parallel cluster execution

## Dependencies

Install required packages via pip:

```bash
pip install -r requirements.txt
```

Or manually:

```bash
pip install numpy torch gym[classic_control] cma scipy imageio
```

> Note: `spiketorch` may need to be installed from source:
>
> ```bash
> python setup.py install
> ```

## Running the Code

### 1. Train with CMA-ES (local machine)

```bash
python train_EI.py
```

### 2. Train on HPC Cluster with SLURM (multi-node)

```bash
sbatch run_training.slurm
```

### 3. Output

- Best evolved parameters (weights + thresholds)
- Saved in `.npy` or `.npz` format for later analysis or deployment

## 4. Evaluation

To evaluate a trained controller manually:

```bash
python evaluation.py
```
