from easydict import EasyDict
import math

v2kwargs={
    'name': 'yolov2',
    'cfgfile': "yolov2.cfg",
    'weightfile': "yolov2.weights",
    'max_lab': 15,
    'batch_size': 8,   # 8
    'old_fasion': False,
}


args_TCA = {
    'crop_type': 'recursive',
    'pooling': 'gauss',
    'pixel_size': [1, 1],
    'pos': None,
    'tps_range': 0.1,
    'tps_canvas': 0.5,
    'n_epochs': 500,
    'learning_rate': 0.03,
    'tv_loss': 1,
    'img_size': 640,        
    'eps': 1e-5,
    'gp': 0,
    'iou_thresh': 0.05,
    'conf_thresh': 0.05,
    'min_contrast' : 0.8,   
    'max_contrast' : 1.2,   
    'min_brightness' : -0.1, 
    'max_brightness' : 0.1, 
    'noise_factor' : 0.10,  
    'minangle' : -20 / 180 * math.pi,  
    'maxangle' : 20 / 180 * math.pi, 
}

targs_TCA = {
    'pos': None,
    'crop_size': [150] * 2,   
    'crop_type': 'recursive',
    'pixel_size': [1] * 2,
    'pooling': 'gauss',
    'img_size': 640,         
    'batch_size': 8,          
    'min_contrast' : 0.8,   # 0.8
    'max_contrast' : 1.2,   # 1.2
    'min_brightness' : -0.1, # -0.1
    'max_brightness' : 0.1,  # 0.1
    'noise_factor' : 0.10,  # 0.10
    'minangle' : -20 / 180 * math.pi,
    'maxangle' : 20 / 180 * math.pi, 
}


kwargs_dict = {
    'yolov2': v2kwargs,
}

args_dict = {
    'TCA': args_TCA,
    }

targs_dict = {
    'TCA': targs_TCA,
    }


def get_cfgs(net_name, method_name, mode='training'):
    if mode == 'training':
        args = args_dict[method_name]
        args = EasyDict(args)
    elif mode == 'test':
        args = targs_dict[method_name]
        args = EasyDict(args)
    else:
        raise ValueError
    kwargs = kwargs_dict[net_name]
    return args, kwargs