import torch
from sd3.pipeline_stable_diffusion_3 import StableDiffusion3Pipeline
from sd3.scheduling_flow_match_euler_discrete import FlowMatchEulerDiscreteScheduler
import random
import os
import glob
import json
from huggingface_hub import hf_hub_download

device = "cuda"
repo = "tensorart/stable-diffusion-3.5-large-TurboX"
ckpt = "Tensorart_TurboX_sd3.5L_8steps.safetensors"

pipe = StableDiffusion3Pipeline.from_pretrained("stabilityai/stable-diffusion-3.5-large", torch_dtype=torch.bfloat16,)
                                                
pipe = pipe.to(device)
pipe.load_lora_weights(hf_hub_download(repo, ckpt))
pipe.fuse_lora()

pipe.scheduler = FlowMatchEulerDiscreteScheduler.from_pretrained(repo, subfolder="scheduler", shift=5)


for idx in range(5000):
    base_name = f"{idx:05d}"
    for i in range(10):
        file_pattern = os.path.join("/path/to/noise", f"{base_name}_{i}*.pt") 
        matching_files = glob.glob(file_pattern)
        filename = matching_files[0] 
        print(filename)

        json_path = os.path.join("/path/to/prompt", f"{idx:05d}.json")
            
        with open(json_path, 'r', encoding='utf-8') as f:
            info = json.load(f)
        prompt = info['caption']
        name_without_extension = filename.split('.')[0] 
        parts = name_without_extension.split('_')  
        last_part = parts[-1] 
        print(last_part)
        seed = int(last_part)

        latents = torch.load(filename).to(device)

        images_, _, noise_, predict_ = pipe(
            prompt = prompt,
            num_inference_steps=8,
            guidance_scale=1.5,
            mid_i=3,
            generator=torch.Generator("cpu").manual_seed(seed),
            continue_to_gen=True,
            mid_latents=latents
        )
        image = images_.images[0]
        os.makedirs("/path/to/output/cofusion", exist_ok=True)    
        image.save("/path/to/output/cofusion/{}_{}_{}.jpg".format(base_name, i, seed))
