import os
import json
import random
import re
import glob
import json
import shutil
import hpsv2
import tqdm

def select_random_images(directory_path, output_path):
    try:
        folder_path = "/path/to/prompts"
        files = os.listdir(directory_path)
        for i in range(5000):    
           
            base_name = f"{i:05d}"
            json_file = os.path.join(folder_path, "{}.json".format(base_name))
            with open(json_file, 'r', encoding='utf-8') as f:
                json_content = json.load(f)
            prompt = json_content['caption']
            pattern = re.compile(f"^{re.escape(base_name)}_\\d+_\\d+\\.jpg$")
            matching_images = [file for file in files if pattern.match(file)]
            best_score = -float('inf')
            best_file = None
                
            if matching_images:
                for file in tqdm.tqdm(matching_images):
                    try:
                        image_path = os.path.join(directory_path, file)
                        score = hpsv2.score(image_path, prompt, hps_version="v2.1")[0]

                        if score > best_score:
                            best_score = score
                            best_file = file
                        
                    except Exception as e:
                        print(f"{file} : {e}")
               
        
            if best_file:
                print(f"{base_name} {best_file}, {best_score:.4f}")
                source_path = os.path.join(directory_path, best_file)
                target_path = os.path.join(output_path, best_file)
                shutil.copy2(source_path, target_path)
                
    except Exception as e:
        print(f"{e}")
        return None


if __name__ == "__main__":
    directory_path = "/path/to/cofusion"
    output_path = "/path/to/output"
    os.makedirs(output_path, exist_ok=True) 
    
    select_random_images(directory_path, output_path)