from sysconfig import get_path
from setuptools import setup, Extension
from pathlib import Path

PATH_PREFIXES = [get_path(p) for p in ["data", "platlib"]]

modules = []
include_dirs = [
    path
    for prefix in PATH_PREFIXES
    for path in [
        f"{prefix}/include/",
        f"{prefix}/include/tbb",
        f"{prefix}/pybind11/include",
    ]
]

for code in ["greedy_encoder", "pco_tokenizer"]:
    modules.append(
        Extension(
            f"pcatt.{code}",
            extra_compile_args=["-O3", "-std=c++23"],
            define_macros=[("MAJOR_VERSION", "0"), ("MINOR_VERSION", "14")],
            include_dirs=include_dirs,
            library_dirs=[f"{prefix}/lib/" for prefix in PATH_PREFIXES],
            libraries=["tbb"],
            sources=[f"pcatt/{code}.cpp"],
        )
    )

this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text()

setup(
    name="greedtok",
    version="0.14",
    description="Partition Cover Approach to Tokenization",
    license="MIT",
    setup_requires=["pybind11", "tbb-devel", "transformers>=4.4"],
    ext_modules=modules,
    long_description=long_description,
    long_description_content_type="text/markdown",
)
