# Data generation: X ~ Uniform[0,1], Y = f_true(x) + noise
gene_data <- function(n, f_true, dis_noise=c('Gaussian', 't'), sigma2, df=5) {
  data_x <- runif(n)
  true_y <- f_true(data_x)
  if (dis_noise == 'Gaussian') {
    par_noise <- sqrt(sigma2)
    noise <- rnorm(n, mean = 0, sd = par_noise)
  } else if (dis_noise == 't') {
    noise <- rt(n, df)
    # noise <- rcauchy(n)
  }
  data_y <- true_y + noise
  list(Y = data_y, X = data_x)
}
