# Define Gaussian kernel
Rep_K <- function(x, y, h = 0.1) {
  exp(- (x - y)^2 / (2 * h^2))
}


inner_product_H <- function(f_vals, g_vals, Kinv_grid) {
  as.numeric(crossprod(f_vals, Kinv_grid %*% g_vals))
}


L2_MSE_compute <- function(res, true_f0, grid, alg_type=c('online', 'offline')) {
  true_f0_val <- true_f0(grid)
  res_num <- length(res)
  L2_mse_vec <- rep(1000, res_num)
  for (i in 1:res_num) {
    if (alg_type == 'online') {
      f_residuals <- (res[[i]] - true_f0_val) ^ 2
    }
    else {
      f_residuals <- (res[[i]] - true_f0_val) ^ 2
    }
    L2_mse_vec[i] <- mean(f_residuals)
  }
  L2_mse_vec
}

