# ——————————————————————————————————————
# Offline kernel update with coefficients a_n
# and averaged iterate \bar g_n
# ——————————————————————————————————————

#   X_all: n-length vector
#   Y_all: n-length response vector
#   gamma0: initial value of learning rate
#   gamma_exp: gamma_i=gamma0*i^(-gamma_exp)
#   kernel: a function kernel(x, z)

# ——————————————————————————————————————

offline_updating <- function(X_all, Y_all, gamma0, gamma_exp, kernel, grid, n_drop) {
  f_est_list <- list()
  
  n <- length(X_all)
  a <- numeric(n)
  csum <- numeric(n)
  
  for(i in seq_len(n)) {
    if (i == 1) {
      g_pred <- 0
    } else {
      Kvec <- kernel(X_all[1:(i-1)], X_all[i])
      g_pred <- sum(a[1:(i-1)] * Kvec)
    }
    
    resn <- Y_all[i] - g_pred
    gamma_i <- gamma0 * i ^ (-gamma_exp)
    a[i] <- gamma_i * resn
  }
  
  csum <- cumsum(a)
  
  ker_xall_grid <- outer(X_all, grid, kernel) # n * lent
    
  for (k in seq_along(record_size)) {
    m <- record_size[k]
    w <- ((m:1) / (m+1)) * a[1:m]
    f_est_list[[k]] <- drop(w %*% ker_xall_grid[1:m,,drop=FALSE])
  }
  
  # return: f_hat_bar at record_id
  f_est_list
}

