# Boosting Parallel Algorithms in Linear Queries for Non-Monotone Submodular Maximization

This repository is the official implementation of Boosting Parallel Algorithms in Linear Queries for
Non-Monotone Submodular Maximization.

This code is based on the work of [Yixin Chen](https://gitlab.com/luciacyx/nm-adaptive-code).

## Dependencies 
- GNU g++
- GNU make utility
- OpenMP
## The source code is organized as follows:
### "src" folder:
- algs.cpp: contains experimental algorithms, including AST, ATG, Ene, PARSKP2, IteratedGreedy, AdaptiveNonmonotoneMax, FastRandomGreedy, LinAST, LinATG, and BoostAdapt.
- binheap.cpp: implements a heap structure.
- mygraph.cpp: includes the data structure setup as a graph.
- gen_er.cpp: to be used for generating ER datasets.
- gen_ba.cpp: to be used for generating BA datasets.
- preprocess.cpp: to be used for preprocessing data into .bin files

### "data" folder:
- grqc.bin: This dataset for Maximum Cut application. We built this dataset from [GrQc Collaboration networks](https://snap.stanford.edu/data/ca-GrQc.html) with 5,242 nodes and 14,496 edges.
- google.bin: This dataset for Maximum Cut application. We built this dataset from [google Web graphs](https://snap.stanford.edu/data/email-Enron.html) with 875,713 nodes and 5,105,039 edges.
- ba.1k.10.bin: This dataset is for the Maximum Cut application. It is generated from Barabási-Albert graphs with 968 nodes.
- astro.bin: This dataset for Revenue Maximization application. We built this dataset from [Astro Physics collaboration network](https://snap.stanford.edu/data/ca-AstroPh.html) with 18,772 nodes and 198,110 edges.
## Binaries
-  `maxcut`, the main program to run all algorithms for cardinality-constrained maximum cut application
-  `revmax`, the main program to run all algorithms for the Revenue Maximization application
-  `preproc`, for preprocessing edge lists to custom binary format
-  `ba`, for generating Barabasi-Albert graphs

## Format of input graph

The programs take as input a custom binary format; the program
`preproc` is provided to convert an undirected edge list format
to the binary format. 

Each line of the edge list describes an edge.
```
<From id> <To id> <Weight (only if weighted)>
```
The node idexes must be nonnegative integers; they are not restricted to lie in any range.
The `Weight` must be an unsigned integer.

If `graph.el` is an edge list in the above format, then
```
preproc graph.el graph.bin
```
generates the `graph.bin` file in the correct binary format to input to the other programs.
## To run the source code, follow these steps:
### Step 1: Build the makefile by running "make" in the project directory.
### Step 2: Test the application using the following commands:
- Revenue Maximization:
```
./revmax -G data/astro.bin -k 160 -a IG -o astro.txt
```
- Maximum Cut:
```
./maxcut -G data/google.bin -k 10 -a IG -o google.txt
```
## Parameters
```
Options:
-G <graph filename in binary format>
-k <cardinality constraint>
-o <outputFileName>
-N <repetitions>
-e <epsilon (default 0.1)>
-d <delta (default 0.1)>
-v [verbose]
-f [fast mode (for algs. using ThresholdSample)]
-r [report round information]
-s [don't print std-deviation]
-a <algorithm>
    TSATG [run ATG (Kuhnle, 2021)]
    TSAST [run AST (Kuhnle, 2021)]
    ANM [run AdaptiveNonmonotoneMax (Fahrbach et al. 2019)]
    IG [run IteratedGreedy (Gupta et al. 2010)]
    FRG [run FastRandomGreedy (Buchbinder et al. 2015)]
    ParSKP2 [run ParSKP2(Cui et al., 2023)]
    LinAST [run LinAst (this work)]
    LinATG [run LinAtg (this work)]
    BoostAdapt [ run BoostAdapt (this work)]
```

## Experimental Setup
Our experiments were conducted on an HPC machine with 64 tasks across 2 nodes.
The specific configuration for HPC is as follows:
```
    #!/bin/bash
    #SBATCH --job-name=Revmax
    #SBATCH --partition=large
    #SBATCH --ntasks=64
    #SBATCH --nodes=2
    #SBATCH --output=%x.%j.out
    #SBATCH --error=%x.%j.err
```
