#ifndef BINHEAP_H
#define BINHEAP_H

#include <vector>
#include <inttypes.h>
using namespace std;

class MinHeap
{
public:
  vector<uint32_t> _vector;
  vector<uint32_t> _vindex;
  vector<int> _vloc;
  
  void BubbleDown(int index);
  void BubbleUp(int index);
  void Heapify();

  MinHeap(uint32_t* array, size_t length);
  MinHeap(const vector<uint32_t>& vector, size_t length);
  MinHeap();
  MinHeap( size_t nNodes );

  void Insert(uint32_t, uint32_t);
  uint32_t GetMin();
  uint32_t extractNode();
  void DeleteMin();
  void DecreaseValue( int loc, int newValue );
  size_t size();

  bool present( uint32_t node ) {
    if(_vloc[node] != -1)
      return true;

    return false;
  }

  void IncreaseValue( int loc, int newValue ) {
    _vector[ _vloc[ loc ] ] = newValue;
    BubbleDown( _vloc[ loc ] );
  }
};

#endif
