# Old installation
## Installation

First install the requirements with via one of the following options:

- Option 1 (requires pipenv):

  ``pipenv install`` (use --skip-lock flag for speedup at your own risk)
      
  ``pipenv shell``

  If the installation causes problems, the following could be a fix:
  ``sudo apt install python3.6-dev``

- Option 2 (requires python 3.6):

  ``pip3 install -r requirements.txt``
  

Next, download our [datasets](https://edmond.mpdl.mpg.de/imeji/collection/tGU9ok0_m2CVfHI8?q=) and extract each dataset to the data/ directory in this repository.


## Old Usage

- Dataset visualization:

    For an easy overview over the datasets use the data/data_visualization.ipynb jupyter notebook.

- Warcraft shortest path experiment: 
    
    Change directory to project root folder.
    
    Run Warcraft shortest path experiment with gradients through Dijkstra:
    
    ``python main.py settings/warcraft_shortest_path/12x12_combresnet.json``
    
    Run Warcraft shortest path baseline ResNet18 experiment:
    
    ``python main.py settings/warcraft_shortest_path/12x12_baseline.json``
    
    The results are stored in the results directory in the project root folder.

## New Installation: 

```
conda create -n warcraft python==3.7
conda activate warcraft
pip install -r requirements.txt
pip install cvxpy diffcp ortools qpth
```

## New Usage: 

    Run Warcraft shortest path experiment with gradients through DijkstraMultiOWADescent:
    
    ``python main.py --trainer_name DijkstraMultiOWADescent --model_name 'PartialResNetMTL' --owa_weight 'gini' --config_file settings/warcraft_shortest_path/12x12_combresnet_multi.json --n_task 3 --task_idx 1 --beta 100 --seed 1``
## Notes

*Contribute*: If you spot a bug or some incompatibility, raise an issue or contribute via a pull request! Thank you!
