import torch
import torch.nn as nn
import numpy as np
import os,sys
from qpth.qp import QPFunction
from torch.autograd import Variable
from torch.nn.parameter import Parameter

​


class LP_SP(nn.Module):

    # Constraint matrix and RHS vector are inputs

    # nFeatures is the number of edges

    def __init__(self, n_edges, constraint_mat, rhs_vec, eps = 1e-3):
        super(LP_SP, self).__init__()

        self.n = n_edges
        self._device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
        self.e = Variable(torch.Tensor())
        self.Q = eps*Variable(torch.eye(self.n)).to(self._device)

        #self.G = constraint_mat.to(self._device) #.unsqueeze(0).expand( nBatch, constraint_mat.shape[0], constraint_mat.shape[1] )
        #self.h = rhs_vec.to(self._device) #.unsqueeze(0).expand( nBatch, constraint_mat.shape[0] )

        Blhs = Variable( torch.cat((-torch.eye(self.n,self.n), torch.eye(self.n,self.n)),0 ).to(self._device) )
        Brhs = Variable( torch.cat((torch.zeros(self.n),torch.ones(self.n)) ).to(self._device) )

        self.G = torch.cat(  (constraint_mat.to(self._device), Blhs) , 0 )
        self.h = torch.cat(   ( rhs_vec.to(self._device),  Brhs )   )

    def forward(self, x):

        nBatch = x.size(0)

        e = self.e
        Q = self.Q
        G = self.G
        h = self.h

        A = e
        b = e

        inputs = x

        print("x = ")
        print( x  )
        print("Q  = ")
        print( Q )
        print("G  = ")
        print( G )
        print("h = ")
        print( h )

        x = QPFunction(verbose=-1)(  Q.double(), inputs.double(), G.double(), h.double(), A.double(), b.double()   )

        x = x.float()

​

​

​

        return x

​

​

​

​

​
