
import os
import sys
import pickle
import random
import torch
import csv
import itertools
from collections import defaultdict, deque
import time
from functools import lru_cache

import ast
import collections
import json
from copy import deepcopy
from warnings import warn
import numpy as np

import re
import shutil
from time import sleep

import numpy as np
import random
import torch

class customdefaultdict(defaultdict):
    def __missing__(self, key):
        if self.default_factory:
            dict.__setitem__(self, key, self.default_factory(key))
            return self[key]
        else:
            defaultdict.__missing__(self, key)


def set_seed(seed):
    if seed is not None:
        random.seed(seed)
        torch.manual_seed(seed)
        torch.cuda.manual_seed(seed)
        np.random.seed(seed)

class AverageMeter(object):
	"""Computes and stores the average and current value"""

	def __init__(self, name=None, fmt=":f"):
	    self.name = name
	    self.fmt = fmt
	    self.reset()

	def reset(self):
	    self.val = 0
	    self.avg = 0
	    self.sum = 0
	    self.count = 0

	def update(self, val, n=1):
	    self.val = val
	    self.sum += val * n
	    self.count += n
	    self.avg = self.sum / self.count

	def __str__(self):
	    fmtstr = "{name} ({avg" + self.fmt + "})"
	    return fmtstr.format(**self.__dict__)